require 'rspec_helper'
require 'varUtility/varUtility_PageObject'
require_relative '../../../acceptance-tests/watir-ruby/pages/vaToolSet/userMenu'
require_relative '../../../acceptance-tests/watir-ruby/pages/launchpad'
require_relative '../../../acceptance-tests/watir-ruby/pages/vaToolSet/landing'
require 'vaToolSet/vaToolSet_pageObject'

class Common
  include PageObject

  def initialize(driver)
    @driver = driver
    @var_po  = VarUtility_PageObject.new(@driver)
    @user_menu = UserMenu.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @landing = Landing.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  def loginEndsOnHome(access_code, verify_code, station)
    # @var_po.landing.login_element.when_visible(TIME_OUT_LIMIT)
    # @var_po.landing.login
    # @var_po.login.login_element.when_visible(TIME_OUT_LIMIT)

    if access_code == "ACCESS50"
      @vts_po.loginLogout.login(UserAccess50)
    else
    @vts_po.loginLogout.login(UserAccess7)
    end


      #@var_po.login.login_with(access_code, verify_code, station)
    # waitWhileSpinnerPresent()
    # @var_po.landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
  end

  def waitWhileSpinnerPresent()
    spinner = @driver.div :css => '.content-loading'
    if (spinner.present?)
      spinner.wait_while_present(TIME_OUT_LIMIT)
    end
  end

  def wait_untill_elements_size_steadied(timeout=TIME_OUT_LIMIT)
    @old_size = 0
    @driver.wait
    wait = Selenium::WebDriver::Wait.new(:timeout => timeout)
    wait.until { elements_size_steadied? }
  end

  def elements_size_steadied?
    current_ele = @driver.element.html
    current_size = current_ele.size
    if @old_size == current_size && current_size > 0
      sleep 0.2
      return true
    else
      @old_size = current_size
    end
    return false
  end

  def clickSaveChangesBtn()
    click(:css,  'button[title="Save Changes"]')
  end

  def clickSaveBtn()
    click(:css, "button[title='Save']")
  end

  def isSaveButtonDisabled()
    element = getElement(:css, 'button[title="Save"]')
    disabled = element.attribute("disabled")

    if(disabled != nil and disabled == "true")
      return true
    else
      return false
    end

  end

  def isSaveChangesDisabled()
    element = getElement(:css, 'button[title="Save Changes"]')
    disabled = element.attribute("disabled")

    puts "Disabled is = " + disabled.to_s

    if(disabled != nil and disabled == "true")
      return true
    else
      return false
    end

  end


def logoutAndLogbackWithADifferentUser(access_code, verify_code, station)
    @var_po.userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)

    menu_button = @driver.button(:id => 'user-menu-toggle-btn')
    @driver.execute_script("$(arguments[0]).click();",menu_button)

    @var_po.userMenu.logOut_element.when_present

    button_element = @driver.button(:id => 'logout')
    @driver.execute_script("$(arguments[0]).click();",button_element)
    sleep(3)
    Watir::Wait.until {@launchpad.launchpadTitle == "Launchpad"}
    @launchpad.launchpadTitle_element.when_visible(TIME_OUT_LIMIT)

    @driver.goto(BASE_URL)
    @landing.login_element.when_visible(TIME_OUT_LIMIT)
    loginEndsOnHome(access_code, verify_code, station)
  end

end
